/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.voiding;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FilterSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.TrashSlot;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterUpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidFilterSettings;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidWidget;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class VoidUpgrade
extends FilterUpgradeBase<VoidUpgrade, VoidFilterSettings>
implements IEnable {
    public VoidUpgrade(UpgradeManager manager, int dataHolderSlot, NonNullList<ItemStack> filter, List<String> filterTags) {
        super(manager, dataHolderSlot, new Point(66, 103), (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.voidUpgradeSettings.filterSlotCount.get(), filter, filterTags);
    }

    @Override
    public List<Integer> getFilter() {
        return (List)this.getDataHolderStack().getOrDefault(ModDataComponents.FILTER_SETTINGS, List.of(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(1)));
    }

    @Override
    public VoidFilterSettings createFilterSettings(UpgradeManager manager, NonNullList<ItemStack> filter, List<String> filterTags) {
        return new VoidFilterSettings(manager.getWrapper().getStorage(), filter.stream().skip(1L).limit(this.getFilterSlotCount()).filter(stack -> !stack.isEmpty()).toList(), this.getFilter(), filterTags);
    }

    public boolean canVoid(ItemStack stack) {
        return ((VoidFilterSettings)this.getFilterSettings()).matchesFilter(null, stack) && this.isEnabled(this);
    }

    @Override
    public ItemStack getFirstFilterStack() {
        return this.filter.getStackInSlot(1);
    }

    public ItemStack getTrashSlotStack() {
        return this.filter.getStackInSlot(0);
    }

    public void voidTrashSlotStack() {
        this.filter.setStackInSlot(0, ItemStack.EMPTY.copy());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public WidgetBase<BackpackScreen> createWidget(BackpackScreen screen, int x, int y) {
        return new VoidWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    @Override
    public List<Slot> getUpgradeSlots(final BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        int activeSlotCount = (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.voidUpgradeSettings.filterSlotCount.get();
        if (this.isTagSelector()) {
            slots.add((Slot)new FilterSlotItemHandler(this, this, (IItemHandler)this.filter, 1, x + 64, y + 23, 2){

                @Override
                public boolean isActive() {
                    return super.isActive();
                }

                @Override
                public boolean mayPlace(ItemStack pStack) {
                    return menu.getWrapper().isOwner(menu.player) && super.mayPlace(pStack);
                }
            });
        } else {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (j + i * 3 == 0) {
                        slots.add((Slot)new TrashSlot(this, this.filter, j + i * 3, x + 7 + j * 18, y + 44 + i * 18, activeSlotCount));
                        continue;
                    }
                    slots.add((Slot)new FilterSlotItemHandler(this, (IItemHandler)this.filter, j + i * 3, x + 7 + j * 18, y + 44 + i * 18, activeSlotCount){

                        @Override
                        public boolean isActive() {
                            return super.isActive() && VoidUpgrade.this.getFilter().get(0) != 2;
                        }

                        @Override
                        public boolean mayPlace(ItemStack pStack) {
                            return menu.getWrapper().isOwner(menu.player) && super.mayPlace(pStack);
                        }
                    });
                }
            }
        }
        return slots;
    }

    @Override
    protected ItemStackHandler createFilter(NonNullList<ItemStack> stacks) {
        return new ItemStackHandler(stacks){

            protected void onContentsChanged(int slot) {
                VoidUpgrade.this.updateDataHolderUnchecked((DataComponentType)ModDataComponents.BACKPACK_CONTAINER.get(), InventoryHelper.itemsToList(9, VoidUpgrade.this.filter));
                ((VoidFilterSettings)VoidUpgrade.this.getFilterSettings()).updateFilter((List<ItemStack>)((BackpackContainerContents)VoidUpgrade.this.getDataHolderStack().get(ModDataComponents.BACKPACK_CONTAINER)).getItems());
                ((VoidFilterSettings)VoidUpgrade.this.getFilterSettings()).updateFilterTags((List)VoidUpgrade.this.getDataHolderStack().get(ModDataComponents.FILTER_TAGS));
                VoidUpgrade.this.changeListeners.forEach(Runnable::run);
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            public int getSlotLimit(int slot) {
                if (slot == 0) {
                    return 64;
                }
                return 1;
            }
        };
    }
}

